	subroutine INIT(iout, idbg, Ne, Nn, Nb, Nm, Nd, NnNd, &
			BCe, BCi, BCn, BCvalue, BCtype, ie, x, nmat, &
			C, &
			vB, &
			rB, &
			cB, &
			lastB, &
			Nr, order, Rr)		! ### new parameters ###
! initialize

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nb, Nm, Nd, NnNd	! array parameters
	integer lastB
	integer BCe(Nb,3), BCi(Nb)		! BC element and local element face numbers
	real*8 BCvalue(Nb,2)			! BC value (jx_bar, qx_bar or c_bar)
	integer rB(Nn+1)			! global  arrays (compact rows)
	integer cB(NnNd)			! global  arrays (compact columns)
	real*8 BCn(Nb,2)			! BC outwards normal
	character*1 BCtype(Nb)			! BC type ('N' or 'D')
	integer ie(Ne,5)			! global connectivity array
	real*8 x(Nn,2)				! global coordinates array
	integer nmat(Nn,0:Nd)			! global nodal materials array
	real*8 C   (Nn)				! global  array
	real*8 vB(NnNd)				! global  arrays (compact values)

	integer N_D, Nr				! ### new parameters ###
	integer order(Nn,0:1)			! ### new parameters ###
	real*8 Rr(Nn)				! ### new parameters ###
	real*8, allocatable ::  Cr(:)		! ### new parameters ###

	integer, allocatable :: rBo(:)			! global  arrays (compact rows)
	integer, allocatable :: cBo(:)			! global  arrays (compact columns)
	real*8, allocatable :: vBo (:)			! global  arrays (compact values)
	integer i, j, k, m, n, md, e, i1, i2, p
	real*8 sx, sy, Lx

!	write(idbg,'(a)') ' --- INIT ---'	! ### TEMPORARY ###

	allocate ( vBo(NnNd), cBo(NnNd), rBo(Nn+1) )

! create a list of the original vs reordered nodes
	call DORDER(iout, idbg, Ne, Nn, Nb, BCe, BCi, BCtype, ie, &
			N_D, order)	! ### new parameters ###

! permute B rows & columns into Bo if Dirichlet BC
	call DPERM (Nn, vB, cB, rB, vBo, cBo, rBo, order(:,1), order(:,1), 1)

	Nr = Nn - N_D		! reduced rows and columns
	allocate(Cr(Nn))	! constant part
	Cr = 0.			! initialize Cr
	do n = 1, Nb

! calculate boundary faces unit normals
	  e = BCe(n,3)	! BC element number
	  i = BCi(n)	! BC local element face number
	  if     (i .eq. 1) then
	    i1 = ie(e,1)
	    i2 = ie(e,2)
	  else if(i .eq. 2) then
	    i1 = ie(e,2)
	    i2 = ie(e,3)
	  else if(i .eq. 3) then
	    i1 = ie(e,3)
	    i2 = ie(e,4)
	  else if(i .eq. 4) then
	    i1 = ie(e,4)
	    i2 = ie(e,1)
	  endif
	  sx = x(i2,1)-x(i1,1)		! i1->i2 x component
	  sy = x(i2,2)-x(i1,2)		! i1->i2 y component
	  Lx = sqrt(sx**2 + sy**2)	! Lx length
	  BCn(n,1) = sy/Lx		! unit normal x component
	  BCn(n,2) =-sx/Lx		! unit normal y component
	  BCe(n,1) = i1			! store BC node 1 in BCe
	  BCe(n,2) = i2			! store BC node 2 in BCe

! replace C(i) by Cbar if Dirichlet BC
	  if(BCtype(n) .eq. 'D') then
	    do p = 1, 2
	      i = BCe(n,p)		! BC global node p number
	      Cr(i) = BCvalue(n,p)
	      C (i) = BCvalue(n,p)
	    enddo	! p
	  endif

	enddo		! n

! permute Cr vector (in-place)
	call DVPERM (Nn, Cr, order(:,1)) 

! calculate {Ra} = [Baa]{0} + [Bab]{Cb}
	call AMUX(Nn, Cr, Rr, vBo, cBo, rBo)
! make {Rb} = 0
	do i = Nr+1, Nn
	  Rr(i) = 0.
	enddo	! i

! extract submatrix Baa into B
	call SUBMAT (Nn ,1, 1, Nr, 1, Nr, vBo, cBo, rBo, Nr, Nr, vB, cB, rB)
	lastB = rB(Nr+1) - rB(1)	! update lastB

	deallocate ( Cr )		! deallocate Cr
	deallocate ( vBo, cBo, rBo )	! deallocate Bo

	return
	end

